-- primer problema
create table centro_minorista(
	id SERIAL primary key,
	tipo varchar(100) not null,
	direccion varchar(150)
);

create table evento_transporte(
	id SERIAL primary key,
	tipo varchar(100) not null,
	ruta_delivery varchar(200) not null
);

create table articulo(
	id SERIAL primary key,
	peso float not null,
	dimensiones varchar(50),
	seguro float not null,
	fecha_entrega date,
	centro_id int REFERENCES centro_minorista(id)
);

create table paquete_evento(
	id SERIAL primary key,
	evento_id int REFERENCES evento_transporte(id),
	articulo_id int REFERENCES articulo(id)
);

INSERT INTO centro_minorista(
	 tipo, direccion)
	VALUES ( 'rapido', 'calle 123');

INSERT INTO evento_transporte(
	 tipo, ruta_delivery)
	VALUES ( 'rapido', 'a despues b');

INSERT INTO articulo(
	 peso, dimensiones, seguro, fecha_entrega, centro_id)
	VALUES ( 100, 'largo ancho', 0, '2020-03-03', 1);

INSERT INTO paquete_evento(
	 evento_id, articulo_id)
	VALUES (1, 1);

-- segundo problema

create table lot(
	lot_number SERIAL primary key,
	create_date date not null,
	cost_of_materials float not null
);

create table raw_material(
	id SERIAL primary key,
	tipo varchar(50) not null,
	unicost float not null
);

create table create_from(
	id SERIAL primary key,
	material_id int REFERENCES raw_material(id),
	lot_id int REFERENCES lot(lot_number),
	units int not null
);

create table production_unit(
	id SERIAL primary key,
	exact_weight float not null,
	product_type varchar(50),
	product_desc varchar(255),
	quality_test boolean not null,
	lot_id int REFERENCES lot(lot_number)
);

insert into create_from(material_id, lot_id, units) values(1, 1, 1000);
insert into lot(create_date,cost_of_materials) values('2020-03-29',500.55);
insert into production_unit(exact_weight, product_type, product_desc, quality_test, lot_id) values(103.43,'remera','lindo',false,1);
insert into raw_material(tipo, unicost) values('tela',100);