public class Stack<T> {
    /**
     * Clase generica de Stack para soportar varios tipos de elementos. float, int, etc
     * 
     */
    public T [] elementos;
    int actual;
    int capacidad;

    public Stack(int cantidad) {
        this.capacidad = cantidad;
        elementos = (T[])new Object[capacidad];
        actual = 0;

    }

    public void push(T valor){
        if(actual==capacidad){
            System.err.println("Pila llena");
            return ;
        }
        elementos[actual] = valor;
        actual += 1;
    }

    public T pop(){
        if(this.estaVacia()){
            System.err.println("Pila vacia");
            return null;
        }
        T valor = elementos[actual-1];
        actual -= 1;
        return valor;
    }

    public boolean estaVacia() {
        return actual<1;
    }

    public T lastValue(){
        return elementos[actual-1];
    }

    public static void main(String[] args) {
        int capacidad = 10, numero;
        Stack<Integer> pila = new Stack<Integer>(capacidad);
        System.out.println("Insertando numeros:");
        for (int i = 0; i < capacidad; i++) {
            numero = Math.round(100*(float)Math.random());
            System.out.print(numero+" ");
            pila.push(numero);
        }
        System.out.println("\nOrdenar Pila");
        ordenarPila(pila);
        //System.out.println("\nMeter en pila llena");
        //pila.push(122);
        //System.out.println("Pila Vacia?"+pila.estaVacia());
        //System.out.println("\nExtrayendo pila");
        for (int i = 0; i < capacidad; i++) {
            System.out.print(pila.pop()+" ");
            
        }
        //System.out.println("\nPila Vacia?"+pila.estaVacia());
        //System.out.println("Extaccion pila vacia");
        //pila.pop(); */


    }

    public static void ordenarPila(Stack<Integer> s) {
        
        if(!s.estaVacia()){
            int temp = s.pop();
            ordenarPila(s);
            insertarEnOrden(temp,s);
        }
        
    }
    public static void insertarEnOrden(int elem, Stack<Integer> s) 
    {
        if (s.estaVacia() || elem > s.lastValue()) {
            s.push(elem);
        } else {
            int temp = s.pop();
            insertarEnOrden(elem, s);
            s.push(temp);
        }    
    }
}
