import java.io.Console;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Mochila {
    private int capacidad;
    private List<Objeto> elementos;

    public Mochila(int capacidad) {
        this.capacidad = capacidad;
        this.elementos = new ArrayList<>();
    }

    public void setCapacidad(int capacidad) {
        this.capacidad = capacidad;
    }
    public int getCapacidad() {
        return capacidad;
    }
    public List<Objeto> getElementos() {
        return elementos;
    }
    public void addElemento(Objeto elemento) {
        this.elementos.add(elemento);
    }

    public void maximoBeneficio(Objeto [] cosas){
        Arrays.sort(cosas, (a,b) -> b.getRatio().compareTo(a.getRatio()));
        int libre=capacidad;
        int cantidadLlevarElemento = 0;
        int index_first_mejor = 0;
        int mejor_index =0;
        int mejor_benefico = 0;
        Objeto objeto;
        int beneficio = 0;
        while(index_first_mejor<cosas.length){
            beneficio = 0;
            libre=capacidad;
            for (int i = index_first_mejor; i < cosas.length; i++) {
                objeto = cosas[i];
                if( objeto.getPeso()<= libre){
                    cantidadLlevarElemento = Math.floorDiv(libre, objeto.getPeso());
                    libre -= (cantidadLlevarElemento * objeto.getPeso());
                    if(beneficio==0) index_first_mejor=i;
                    beneficio += (cantidadLlevarElemento * objeto.getValor());
                }
                if(libre==0){
                    break;
                }

            }
            if(beneficio>mejor_benefico){
                mejor_index = index_first_mejor;
                mejor_benefico = beneficio;
            }
            index_first_mejor++;
        }
        beneficio = 0;
        libre = capacidad;
        for (int i = mejor_index; i < cosas.length; i++) {

            objeto = cosas[i];
            if( objeto.getPeso()<= libre){
                cantidadLlevarElemento = Math.floorDiv(libre, objeto.getPeso());
                for (int j = 0; j < cantidadLlevarElemento; j++) {
                    elementos.add(objeto);
                }
                libre -= (cantidadLlevarElemento * objeto.getPeso());
                beneficio += (cantidadLlevarElemento * objeto.getValor());
            }
            if(libre==0){
                break;
            }

        }
    }

    public static void main(String[] args) {
        Console cons = System.console();
        String pesosS = cons.readLine("Introduzca valores separados por coma de los pesos de los elementos\n");
        String valoresS = cons.readLine("Introduzca valores separados por coma de los valores de los elementos\n");
        String [] pesos = pesosS.split(",");
        String [] valores = valoresS.split(",");
        Objeto [] elementos = new Objeto[pesos.length];
        for (int i = 0; i < pesos.length ; i++) {
            elementos[i] = new Objeto(Integer.parseInt(valores[i]), Integer.parseInt(pesos[i]));
        }
        String capS = cons.readLine("Introduzca capacidad de la mochila\n");
        int cap = Integer.parseInt(capS);
        Mochila mochila = new Mochila(cap);
        mochila.maximoBeneficio(elementos);
        System.out.println("Se escogen estos elementos");
        mochila.getElementos().stream().forEach(e -> System.out.println(e));
        
        
        

    }
    
}

class Objeto{
    private int valor;
    private int peso;
    private Float ratio;
    public Objeto(int valor, int peso) {
        this.valor = valor;
        this.peso = peso;
        this.ratio = ((float)this.valor)/this.peso;
    }
    public int getPeso() {
        return peso;
    }
    public int getValor() {
        return valor;
    }
    public void setPeso(int peso) {
        this.peso = peso;
    }
    public void setValor(int valor) {
        this.valor = valor;
    }
    public Float getRatio() {
        return ratio;
    }
    public void setRatio(float ratio) {
        this.ratio = ratio;
    }
    @Override
    public String toString() {
        
        return "{Valor: " + valor + ",Peso: " + peso + ",Ratio:"+ratio+"}" ; 
    }
}
