import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Juego {
    List<Integer> valores = null;

    public Juego() {
    }

    public void juegosPosibles(List<Carta> cartas) {
        boolean siguiente = true;
        if (escaleraColor(cartas)) {
            siguiente = false;
            System.out.println("ESCALERA COLOR");
        }
        if (siguiente && poker(cartas)) {
            siguiente = false;
            System.out.println("POKER");
        }
        if (siguiente && escalera(cartas)) {
            siguiente = false;
            System.out.println("ESCALERA");
        }
        if (siguiente && color(cartas)) {
            siguiente = false;
            System.out.println("COLOR");
        }
        if (siguiente) {
            System.out.println("NADA");
        }
    }

    //Cuatro cartas iguales (mismo valor).
    public boolean poker(List<Carta> cartas) {
        List<Integer> valores = new ArrayList<>();
        for (Carta c : cartas) {
            valores.add(extraer(c.valor));
        }
        Collections.sort(valores);
        int counter=0;
        int numero=0;
        int cantidadNumero=0;
        for(int i=1; i<14; i++){
            for (int j=0; j<valores.size(); j++) {
                int s= valores.get(j);
                if(s == i){
                    counter++;
                }
            }
            if(counter > cantidadNumero){
                numero=i;
                cantidadNumero=counter;
            }
            counter=0;
        }
        if (cantidadNumero==4){
            return true;
        }else {
            return false;
        }

    }

    public boolean color(List<Carta> cartas) {
        String valuePalo = estraerPalo(cartas);
        for (int i = 0; i < cartas.size(); i++) {
            if (!valuePalo.equals(cartas.get(i).palo)) {
                return false;
            }
        }
        return true;
    }

    public boolean escalera(List<Carta> cartas) {
        int contador = 0;
        List<Integer> valores = new ArrayList<>();

        for (Carta c : cartas) {
            valores.add(extraer(c.valor));
        }
        Collections.sort(valores);
        valores.forEach(System.out::println);

        int[] valoresArry = pasarAArray(valores);
        for (int i = 0; i < valoresArry.length - 1; i++) {

            if (valoresArry[i] > 1) {
                if (valoresArry[i + 1] - valoresArry[i] != 1) {
                    return false;
                }
            }

            contador += valoresArry[i];
            if (contador == 34 && valoresArry[0] == 1) {
                return true;
            }
        }
        return true;
    }

    public boolean escaleraColor(List<Carta> cartas) {
        boolean valor1 = true;
        String valuePalo = estraerPalo(cartas);
        for (int i = 0; i < cartas.size(); i++) {
            if (!valuePalo.equals(cartas.get(i).palo)) {
                valor1 = false;
            }
        }
        int contador = 0;
        List<Integer> valores = new ArrayList<>();
        if (valor1) {
            for (Carta c : cartas) {
                valores.add(extraer(c.valor));
            }
            Collections.sort(valores);
            valores.forEach(System.out::println);

            int[] valoresArry = pasarAArray(valores);
            for (int i = 0; i < valoresArry.length - 1; i++) {

                if (valoresArry[i] > 1) {
                    if (valoresArry[i + 1] - valoresArry[i] != 1) {
                        return false;
                    }
                }

                contador += valoresArry[i];
                if (contador == 34 && valoresArry[0] == 1) {
                    return true;
                }
            }
            return true;
        }

        return false;

    }

    private int[] pasarAArray(List<Integer> valores) {
        int[] value = new int[5];
        for (int i = 0; i < valores.size(); i++) {
            value[i] = valores.get(i);
        }
        return value;
    }

    public Integer extraer(String carta) {
        int valor = 0;
        if (carta.equals("A")) {
            return valor = 1;
        }
        if (carta.equals("T")) {
            return valor = 10;
        }
        if (carta.equals("J")) {
            return valor = 11;
        }
        if (carta.equals("Q")) {
            return valor = 12;
        }
        if (carta.equals("K")) {
            return valor = 13;
        }
        return Integer.valueOf(carta);
    }

    public String estraerPalo(List<Carta> cartas) {
        String value = "";
        for (Carta c : cartas) {
            value = c.palo;
            break;
        }
        return value;
    }

}
