import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Juego {
    List<Integer> valores = null;
    final int MAX = 3;
    final int MIN = 1;

    public Juego() {
    }

    public int mano1VsMano2(int carta1, int carta2) {
        if (carta1 > carta2) {
            return 1;
        } else if (carta1 < carta2) {
            return 2;
        } else if (carta1 == carta2) {
            return 0;
        }
        return 0;
    }

    public void desempateCarta(int cartas1, int cartas2) {
        if (cartas1 > cartas2) {
            System.out.println("1");
        }
        System.out.println("2");
    }

    public int sumaManoValores(Carta[] cartas) {
        List<Integer> valores = new ArrayList<>();
        int contador = 0;
        for (Carta c : cartas) {
            valores.add(convertirValorStringAInteger(c.getValor()));
            contador++;
        }
        return contador;
    }

    public int juegosPosibles(List<Carta> cartas) {
        if (escaleraColor(cartas)) {
            System.out.println("ESCALERA COLOR");
            return 9;
        }
        if (poker(cartas)) {
            System.out.println("ESCALERA COLOR");
            return 8;
        }
        if (full(cartas)) {
            System.out.println("FULL");
            return 7;
        }
        if (escalera(cartas)) {
            System.out.println("ESCALERA");
            return 6;
        }
        if (color(cartas)) {
            System.out.println("COLOR");
            return 5;
        }
        if (trio(cartas)) {
            System.out.println("TRIO");
            return 4;
        }
        if (parDoble(cartas)) {
            System.out.println("PAR DOBLE");
            return 3;
        }
        if (par(cartas)) {
            System.out.println("PAR");
            return 1;
        }
        System.out.println("CARTA ALTA");
        return 0;
    }

    public boolean par(List<Carta> cartas) {
        if (cantidadPalosIguales(cartas) < 3) {
            List<Integer> valores = new ArrayList<>();
            for (Carta c : cartas) {
                valores.add(convertirValorStringAInteger(c.getValor()));
            }
            Collections.sort(valores);
            int[] numerosArray = pasarAArray(valores);
            int con = 0;
            for (int i = 0; i < numerosArray.length - 1; i++) {
                if (numerosArray[i] == numerosArray[i + 1]) {
                    con++;
                    if (con == 1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean parDoble(List<Carta> cartas) {
        if (cantidadPalosIguales(cartas) < 3) {
            List<Integer> valores = new ArrayList<>();
            for (Carta c : cartas) {
                valores.add(convertirValorStringAInteger(c.getValor()));
            }
            Collections.sort(valores);
            int[] numerosArray = pasarAArray(valores);
            int con = 0;
            for (int i = 0; i < numerosArray.length - 1; i++) {
                if (numerosArray[i] == numerosArray[i + 1]) {
                    con++;
                    if (con == 2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean trio(List<Carta> cartas) {
        List<Integer> valores = new ArrayList<>();
        for (Carta c : cartas) {
            valores.add(convertirValorStringAInteger(c.getValor()));
        }
        //Collections.sort(valores);
        int[] numerosArray = pasarAArray(valores);
        int counter = 0;
        int cantidadNumero = 0;
        for (int i = 11; i < 14; i++) {
            for (int j = 0; j < numerosArray.length - 1; j++) {
                if (numerosArray[j] == numerosArray[j + 1]) {
                    counter++;
                }
            }
            if (counter > cantidadNumero) {

                cantidadNumero = counter;
            }
            counter = 0;
        }

        if (cantidadNumero == 3) {
            return true;
        } else {
            return false;
        }
    }

    //Dos cartas iguales (mismo valor) junto con tres cartas iguales (mismo valor).
    public boolean full(List<Carta> cartas) {
        if (cantidadPalosIguales(cartas) == 3) {
            List<Integer> valores = new ArrayList<>();
            for (Carta c : cartas) {
                valores.add(convertirValorStringAInteger(c.getValor()));
            }
            Collections.sort(valores);
            int[] numerosArray = pasarAArray(valores);
            int con = 0;
            for (int i = 0; i < numerosArray.length - 1; i++) {
                if (numerosArray[i] == numerosArray[i + 1]) {
                    con++;
                    if (con == 3 && numerosArray[2] == numerosArray[4]) {
                        return true;
                    } else if (con == 3 && numerosArray[2] == numerosArray[0]) {
                        return true;
                    }
                }
            }
            return false;
        } else {
            return false;
        }
    }

    //Cuatro cartas iguales (mismo valor).
    public boolean poker(List<Carta> cartas) {
        List<Integer> valores = new ArrayList<>();
        cantidadPalosIguales(cartas);
        for (Carta c : cartas) {
            valores.add(convertirValorStringAInteger(c.getValor()));
        }
        Collections.sort(valores);
        int counter = 0;
        int cantidadNumero = 0;
        for (int i = 1; i < 14; i++) {
            for (int j = 0; j < valores.size(); j++) {
                int s = valores.get(j);
                if (s == i) {
                    counter++;
                }
            }
            if (counter > cantidadNumero) {
                cantidadNumero = counter;
            }
            counter = 0;
        }
        if (cantidadNumero == 4) {
            return true;
        } else {
            return false;
        }


    }

    private int cantidadPalosIguales(List<Carta> cartas) {
        int contador = 0;
        for (Carta c : cartas) {

            if (c.getPalo().equals("K")) {
                contador++;
            }
            if (c.getPalo().equals("Q")) {
                contador++;
            }
            if (c.getPalo().equals("K")) {
                contador++;
            }
            if (c.getPalo().equals("C")) {
                contador++;
            }
        }

        return contador;

    }

    public boolean color(List<Carta> cartas) {
        String valuePalo = estraerPrimerPalo(cartas);
        for (int i = 0; i < cartas.size(); i++) {
            if (!valuePalo.equals(cartas.get(i).getPalo())) {
                return false;
            }
        }
        return true;
    }

    public boolean escalera(List<Carta> cartas) {
        int contador = 0;
        List<Integer> valores = new ArrayList<>();

        for (Carta c : cartas) {
            valores.add(convertirValorStringAInteger(c.getValor()));
        }
        Collections.sort(valores);

        int[] valoresArry = pasarAArray(valores);
        for (int i = 0; i < valoresArry.length - 1; i++) {

            if (valoresArry[i] > 1) {
                if (valoresArry[i + 1] - valoresArry[i] != 1) {
                    return false;
                }
            }

            contador += valoresArry[i];
            if (contador == 21 && valoresArry[0] == 1) {
                return true;
            }
        }
        return true;
    }

    public boolean escaleraColor(List<Carta> cartas) {
        boolean valor1 = true;
        String valuePalo = estraerPrimerPalo(cartas);
        for (int i = 0; i < cartas.size(); i++) {
            if (!valuePalo.equals(cartas.get(i).getPalo())) {
                valor1 = false;
            }
        }
        int contador = 0;
        List<Integer> valores = new ArrayList<>();
        if (valor1) {
            for (Carta c : cartas) {
                valores.add(convertirValorStringAInteger(c.getValor()));
            }
            Collections.sort(valores);

            int[] valoresArry = pasarAArray(valores);
            for (int i = 0; i < valoresArry.length - 1; i++) {

                if (valoresArry[i] > 1) {
                    if (valoresArry[i + 1] - valoresArry[i] != 1) {
                        return false;
                    }
                }
                contador += valoresArry[i];
                if (contador == 34 && valoresArry[0] == 1) {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private int[] pasarAArray(List<Integer> valores) {
        int[] value = new int[5];
        for (int i = 0; i < valores.size(); i++) {
            value[i] = valores.get(i);
        }
        return value;
    }

    public Integer convertirValorStringAInteger(String carta) {
        int valor = 0;
        if (carta.equals("A")) {
            return valor = 1;
        } else if (carta.equals("T")) {
            return valor = 10;
        } else if (carta.equals("J")) {
            return valor = 11;
        } else if (carta.equals("Q")) {
            return valor = 12;
        } else if (carta.equals("K")) {
            return valor = 13;
        }
        return Integer.valueOf(carta);
    }

    public String estraerPrimerPalo(List<Carta> cartas) {
        String value = "";
        for (Carta c : cartas) {
            value = c.getPalo();
            break;
        }
        return value;
    }

    public boolean isRepetidos(Carta[] m1, Carta[] m2) {
        Set<Carta> cartas = new HashSet<>();
        int c = 5;
        for (int i = 0; i < 10; i++) {
            if (i < 5) {
                cartas.add(m1[i]);
            } else if (i > 4) {
                cartas.add(m2[i - c]);
            }
        }
        if (cartas.size() < 10) {
            return false;
        }
        return true;
    }

}


