import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Carta {
    private String valor;
    private String palo;
    private final int MIN=1;
    private final int MAX=4;

    public Carta() {
        valorAleatorio();
        paloAleatorio();
    }

    public String getValor() {
        return valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public String getPalo() {
        return palo;
    }

    public void setPalo(String palo) {
        this.palo = palo;
    }

    public Carta(String completo) {
        String a = String.valueOf(completo.charAt(0));
        String b = String.valueOf(completo.charAt(1));
        this.valor = a.toUpperCase();
        this.palo = b.toUpperCase();
    }

    String valorPalo() {
        return this.valor + this.palo;
    }

    public void valorAleatorio(){
        int max = 13;
        int range = max - MIN + 1;
        int rand = (int)(Math.random() * range) + MIN;
        for (int i = 0; i < 1; i++) {
            if(rand==10){
                this.valor="T";
            }
            else if(rand==11){
                this.valor="J";
            }
            else if(rand==12){
                this.valor="Q";
            }
            else if(rand==13){
                this.valor="K";
            }
            else if (rand==1) {
                this.valor="A";
            } else {
                this.valor=String.valueOf(rand);
            }
        }
    }

    public void paloAleatorio(){
        int range = MAX - MIN + 1;
        int rand = (int)(Math.random() * range) + MIN;
        for (int i = 0; i < 1; i++) {
            if(rand==1){
                this.palo="C";
            }
            else if (rand==2){
                this.palo="H";
            }
            else if(rand==4){
                this.palo="D";
            }else {
                this.palo="S";
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Carta carta = (Carta) o;
        return Objects.equals(valor, carta.valor) && Objects.equals(palo, carta.palo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valor, palo);
    }

    @Override
    public String toString() {
        return "Carta{" +
                "valor='" + valor + '\'' +
                ", palo='" + palo + '\'' +
                '}';
    }
}
