package twitter;

import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Pattern;

public class Usuario {
    private String nombreUsuario;
    private String contrasenha;
    private String correo;
    private Date fechaNacimiento;
    private Date fechaRegistro;
    private String fotoUrl;
    private String descripcion;
    public Seguimiento seguimiento;
    public Dashboard dashboard;
    //    private Tweet[] tweets;
//    private Seguimiento seguimiento;

    public Usuario(String nombreUsuario, String contrasenha, String correo,
                   Date fechaNacimiento, Date fechaRegistro, String fotoUrl,
                   String descripcion, boolean esVerficado) {
        this.nombreUsuario = nombreUsuario;
        this.contrasenha = contrasenha;
        this.correo = correo;
        this.fechaNacimiento = fechaNacimiento;
        this.fechaRegistro = fechaRegistro;
        this.fotoUrl = fotoUrl;
        this.descripcion = descripcion;
        this.esVerficado = esVerficado;
        this.seguimiento = new Seguimiento(this);
        this.dashboard = new Dashboard(this);
    }

    private boolean esVerficado;



    public Usuario(String nombreUsuario, String contrasenha, String correo,
                   String descripcion) {
        this.nombreUsuario = nombreUsuario;
        this.contrasenha = contrasenha;
        this.correo = correo;
        this.descripcion = descripcion;
        this.seguimiento = new Seguimiento(this);
        this.dashboard = new Dashboard(this);
    }


    public static Usuario registarUsuario(){
        /*
        * Funcion que crea un usuario y lo retorna para ser guardado.
        * */
        Scanner in = new Scanner(System.in);
        String username;
        String password;
        String mail;
        String fotoUrl;
        String descripcion;
        try{
            System.out.print("\nIngrese nombre de usuario: ");
            username = in.nextLine();
            System.out.print("\nIngrese contrasenha: ");
            password = in.nextLine();
            System.out.print("\nIngrese mail: ");
            mail = in.nextLine();
            if(!mailRegexCheck(mail.toUpperCase())) {System.out.print("\nFormato de Mail Incorrecto"); return null;}
            System.out.print("\nIngrese una descripcion: ");
            descripcion = in.nextLine();
            return new Usuario(username, password, mail, descripcion);
        }catch (Exception e){
            System.out.println("Un error");
        }
        return null;
    }

    public static Usuario iniciarSesion(){
        /*
        Retorna usuario si las credenciales son correctas, null en caso contrario
         */
        Scanner in = new Scanner(System.in);
        String username;
        String password;
        try{
            System.out.print("\nIngrese su Nombre de Usuario: ");
            username = in.nextLine();
            System.out.print("\nIngrese su Contrasenha: ");
            password = in.nextLine();
            Usuario u = Objects.requireNonNull(BaseDeDatos.getUsuarioByUsername(username));
             if(u.getContrasenha().equals(password)){
                 return u;
             }else{
                 System.out.println("Credenciales Incorrectas!");
                 return null;
             }
        }catch (Exception e){
            System.out.println("Credenciales Incorrectas!");
        }
        return null;
    }


    public String getNombreUsuario() {
        return nombreUsuario;
    }

    public String getContrasenha() {
        return contrasenha;
    }

    public String getCorreo() {
        return correo;
    }

    public Date getFechaNacimiento() {
        return fechaNacimiento;
    }

    public Date getFechaRegistro() {
        return fechaRegistro;
    }

    public String getFotoUrl() {
        return fotoUrl;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public boolean isEsVerficado() {
        return esVerficado;
    }

    private static boolean mailRegexCheck(String mail){
        return Pattern.matches("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", (CharSequence) mail);
    }
}
