package twitter;

import java.util.ArrayList;
import java.util.Scanner;

public class Tweet {
    private Usuario usuario;
    private String text;
    private int numeroRt;
    private int numeroFav;
    private String imageUrl;
    private String linkUrl;
    private ArrayList<Reaccion> reacciones;
    private ArrayList<Respuesta> respuestas;


    public Tweet(Usuario usuario, String text, String imageUrl, String linkUrl) {
        this.usuario = usuario;
        this.text = text;
        this.imageUrl = imageUrl;
        this.linkUrl = linkUrl;
        this.numeroFav = 0;
        this.numeroRt = 0;
        this.respuestas = new ArrayList<Respuesta>();
        this.reacciones = new ArrayList<Reaccion>();
    }

    public static void likear(Usuario usuario, int tweetId){
        BaseDeDatos.getTweetById(tweetId).addLike(usuario);
    }

    public void addLike(Usuario usuario){
        for(Reaccion reaccion: reacciones){
            if(reaccion.getUsuario()==usuario && reaccion.getTipoDeReaccion().equals("LIKE")){
                System.out.println("Ya diste like a esta publicacion");
                return;
            }
        }
        Reaccion newReaccion = new Reaccion(usuario, this, "LIKE");
        this.reacciones.add(newReaccion);
        BaseDeDatos.addReaccion(newReaccion);
        this.numeroFav++;
    }

    public static void retweetear(Usuario usuario, int tweetId){
        BaseDeDatos.getTweetById(tweetId).addRt(usuario);
    }

    public void addRt(Usuario usuario){
        for(Reaccion reaccion: reacciones){
            if(reaccion.getUsuario()==usuario && reaccion.getTipoDeReaccion().equals("RT")){
                System.out.println("Ya diste rt a esta publicacion");
                return;
            }
        }
        Reaccion newReaccion = new Reaccion(usuario, this, "RT");
        this.reacciones.add(newReaccion);
        BaseDeDatos.addReaccion(newReaccion);
        this.numeroRt++;
    }

    public static void responder(Usuario usuario, int tweetId){
        BaseDeDatos.getTweetById(tweetId).addRespuesta(usuario);
    }

    public void addRespuesta(Usuario usuario){
        respuestas.add(Respuesta.tweetear(usuario, this));
    }

    public static void tweetear(Usuario user){
        Scanner in = new Scanner(System.in);
        String text;
        String imageUrl=null;
        String linkUrl=null;
        String choice;
        try{
            System.out.println("Texto");
            System.out.print("----->  ");
            text = in.nextLine();
            System.out.print("\nDesea agregar una imagen al tweet?(Y/N): ");
            choice = (in.nextLine()).toLowerCase();
            if(choice.equals("y")){
                System.out.print("\nURL De la Imagen: ");
                imageUrl = in.nextLine();
            }
            System.out.print("\nDesea agregar un link al tweet?(Y/N): ");
            choice = (in.nextLine()).toLowerCase();
            if(choice.equals("y")){
                System.out.print("\nURL: ");
                linkUrl = in.nextLine();
            }
            BaseDeDatos.addTweet(new Tweet(user, text, imageUrl, linkUrl));
        }catch (Exception e){
            System.out.println("Error");
        }
    }

    public Usuario getUsuario() {
        return usuario;
    }

    public String getText() {
        return text;
    }

    public int getNumeroRt() {
        return numeroRt;
    }

    public int getNumeroFav() {
        return numeroFav;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public ArrayList<Respuesta> getRespuestas() {
        return respuestas;
    }
}
