package twitter;

import java.util.Date;
import java.util.Scanner;

public class TestTwitter {
    public static void main(String []args){
        testData();
        Scanner in = new Scanner(System.in);
        System.out.println("WELCOME TO TWITTER");
        boolean continuar = true;
        int choice = 0;
        Usuario loggedUser = null;

        do{
            if(loggedUser == null){
                System.out.print("\nMenu de Inicio:\n"+
                        "1 - Iniciar Sesion\n"+
                        "2 - Registrarse\n"+
                        "0 - Salir\n"+
                        "Entrada: ");
                try{
                    choice = in.nextInt();
                }catch (Exception e){
                    System.out.println("Entrada no validad");
                    in.reset();
                }
                switch (choice){
                    case 1:
                        System.out.println("Inciando sesion");
                        loggedUser = Usuario.iniciarSesion();
                        break;
                    case 2:
                        System.out.println("Registrandose");
                        BaseDeDatos.addUsuario(Usuario.registarUsuario());
                        break;
                    case 0:
                        System.out.println("Saliendo...");
                        continuar = false;
                        break;
                    default:
                        choice = 0;
                        System.out.println("Eleccion no validad");
                }
            }else{
                System.out.print("\nMenu de Usuario:\n"+
                        "1 - Ver Tweets\n"+
                        "2 - Twittear\n"+
                        "3 - Seguimiento\n"+
                        "4 - Bloqueados\n"+
                        "5 - Ver Mis Likes\n"+
                        "6 - Ver mis RTs\n"+
                        "0 - Cerrar Sesion\n"+
                        "Entrada: ");
                int choice3=0;
                try{
                    choice3 = in.nextInt();
                }catch (Exception e){
                    System.out.println("Entrada no validad");
                }
                switch (choice3){
                    case 1:
                        System.out.print("\nDashboard: ");
                        loggedUser.dashboard.verUltimosTweets(10);
                        System.out.print("\n1 - Responder"+
                                "\n2 - Dar Fav"+
                                "\n3 - Retweetear"+
                                "\n4 - Volver"+
                                "\nEntrada: ");
                        int choice4 = 0;
                        int id;
                        try{
                            choice4 = in.nextInt();
                        }catch (Exception e){
                            System.out.println("Eleccion no valida");
                        }
                        switch (choice4){
                            case 1:
                                System.out.print("\nID de Tweet a responder: ");
                                id = in.nextInt();
                                Tweet.responder(loggedUser, id);
                                break;
                            case 2:
                                System.out.print("\nID de Tweet a dar like: ");
                                id = in.nextInt();
                                Tweet.likear(loggedUser, id);
                                break;
                            case 3:
                                System.out.print("\nID de Tweet a dar RT: ");
                                id = in.nextInt();
                                Tweet.retweetear(loggedUser, id);
                                break;
                            default:
                                choice4 = 0;
                                break;
                        }
                        break;
                    case 2:
                        System.out.println("Twitteando");
                        Tweet.tweetear(loggedUser);
                        break;
                    case 3:
                        System.out.print("\nMenu de Seguimiento: ");
                        System.out.print("\nSeguimiento: ");
                        System.out.print("\n\tSeguidores: ");
                        loggedUser.seguimiento.printSeguidores();
                        System.out.print("\n\tSeguidos: ");
                        loggedUser.seguimiento.printSeguidos();
                        System.out.print("\n1 - Seguir"+
                                "\n2 - Deja de Seguir"+
                                "\n3 - Bloquear"+
                                "\n4 - Desbloquear"+
                                "\n5 - Volver"+
                                "\nEntrada: ");
                        int choice2 = 0;
                        try{
                            choice2 = in.nextInt();
                        }catch (Exception e){
                            System.out.println("Eleccion no valida");
                        }
                        switch (choice2){
                            case 1:
                                loggedUser.seguimiento.seguir();
                                break;
                            case 2:
                                loggedUser.seguimiento.dejarDeSeguir();
                                break;
                            case 3:
                                loggedUser.seguimiento.bloquear();
                                break;
                            case 4:
                                loggedUser.seguimiento.desbloquear();
                                break;
                            default:
                                choice2=0;
                                break;
                        }
                        break;
                    case 4:
                        System.out.print("\nBloqueados: ");
                        loggedUser.seguimiento.printBloqueados();
                        break;
                    case 5:
                        Reaccion.verReaccionUsuario(loggedUser, "LIKE");
                        break;
                    case 6:
                        Reaccion.verReaccionUsuario(loggedUser, "RT");
                        break;
                    case 0:
                        System.out.println("Saliendo...");
                        loggedUser = null;
                        break;
                    default:
                        System.out.println("Eleccion no validad");
                        choice3=0;
                }
            }

        }while(continuar);

    }

    private static void testData(){
        for(int i=0;i<10;i++){
            BaseDeDatos.addUsuario(new Usuario("user"+i, "user"+i,
                    "correo"+i, new Date(), new Date(), "fotoUrl"+i,
                    "descripcion"+i, i%2 == 0));
        }
        for(int i=0;i<10;i++){
            Usuario user = BaseDeDatos.getUsuarioByUsername("user"+i);
            for(int j=0;j<5;j++){
                BaseDeDatos.addTweet(new Tweet(user, "Test Tweet"+(i*5+j),
                        "C:/path.test"+(i*5+j)+".jpg",
                        "https://link/test"+(i*5+j)+".com"));
            }
        }
    }

}
