package twitter;

import java.util.ArrayList;
import java.util.Scanner;

public class Seguimiento {
    private Usuario usuario;
    private ArrayList<Usuario> seguidos;
    private ArrayList<Usuario> seguidores;
    private ArrayList<Usuario> bloqueados;

    public Seguimiento(Usuario usuario) {
        this.usuario = usuario;
        this.seguidores = new ArrayList<Usuario>();
        this.seguidos = new ArrayList<Usuario>();
        this.bloqueados = new ArrayList<Usuario>();
    }

    public void seguir(){
        Scanner in = new Scanner(System.in);
        try{
            System.out.print("\nIngrese el usuario a seguir: ");
            Usuario usuario = BaseDeDatos.getUsuarioByUsername(in.nextLine());
            if(usuario!=null){
                this.seguidos.add(usuario);
                usuario.seguimiento.addSeguidores(this.usuario);
                return;
            }
            System.out.println("Usuario No Existente");
        }catch (Exception e){
            System.out.println("error");
        }
    }

    public void dejarDeSeguir(){
        Scanner in = new Scanner(System.in);
        try{
            System.out.print("\nIngrese el usuario a dejar de seguir: ");
            Usuario usuario = BaseDeDatos.getUsuarioByUsername(in.nextLine());
            if(usuario!=null){
                this.seguidos.remove(usuario);
                usuario.seguimiento.removeSeguidores(this.usuario);
                return;
            }
            System.out.println("Usuario No Existente");
        }catch (Exception e){
            System.out.println("error");
        }
    }

    public void bloquear(){
        Scanner in = new Scanner(System.in);
        try{
            System.out.print("\nIngrese el usuario a bloquear: ");
            Usuario usuario = BaseDeDatos.getUsuarioByUsername(in.nextLine());
            if(usuario!=null){
                this.bloqueados.add(usuario);
                return;
            }
            System.out.println("Usuario No Existente");
        }catch (Exception e){
            System.out.println("error");
        }
    }

    public void desbloquear(){
        Scanner in = new Scanner(System.in);
        try{
            System.out.print("\nIngrese el usuario a desbloquear: ");
            Usuario usuario = BaseDeDatos.getUsuarioByUsername(in.nextLine());
            if(usuario!=null){
                this.bloqueados.remove(usuario);
                return;
            }
            System.out.println("Usuario No Existente");
        }catch (Exception e){
            System.out.println("error");
        }
    }

    public void addSeguidores(Usuario usuario){
        this.seguidores.add(usuario);
    }

    public void removeSeguidores(Usuario usuario){
        this.seguidores.remove(usuario);
    }

    public Usuario getUsuario() {
        return usuario;
    }

    public ArrayList<Usuario> getSeguidos() {
        return seguidos;
    }

    public void printSeguidos(){
        for(Usuario user: seguidos){
            System.out.print("\n\t--"+user.getNombreUsuario());
        }
    }

    public void printSeguidores(){
        for(Usuario user: seguidores){
            System.out.print("\n\t--"+user.getNombreUsuario());
        }
    }

    public void printBloqueados(){
        for(Usuario user: bloqueados){
            System.out.print("\n\t--"+user.getNombreUsuario());
        }
    }

    public ArrayList<Usuario> getSeguidores() {
        return seguidores;
    }

    public ArrayList<Usuario> getBloqueados() {
        return bloqueados;
    }
}
