package twitter;

public class Reaccion {
    private Usuario usuario;
    private Tweet tweet;
    private String tipoDeReaccion;

    public Reaccion(Usuario usuario, Tweet tweet, String tipoDeReaccion) {
        this.usuario = usuario;
        this.tweet = tweet;
        this.tipoDeReaccion = tipoDeReaccion;
    }

    public Usuario getUsuario() {
        return usuario;
    }

    public Tweet getTweet() {
        return tweet;
    }

    public String getTipoDeReaccion() {
        return tipoDeReaccion;
    }

    public static void verReaccionUsuario(Usuario usuario, String tipoDeReaccion){
        System.out.print("\nTweets likeados por usuario: "+usuario.getNombreUsuario());
        for(Reaccion reaccion: BaseDeDatos.getReacciones()){
            if(reaccion.getTipoDeReaccion().equals(tipoDeReaccion) && reaccion.getUsuario()==usuario){
                System.out.print("\n---------------------");
                System.out.print("\n\tAutor: "+reaccion.getTweet().getUsuario().getNombreUsuario()+
                        "\n\tTexto: "+reaccion.getTweet().getText());
                System.out.print("\n\tLikes: "+reaccion.getTweet().getNumeroFav()+"\tRts: "+reaccion.getTweet().getNumeroRt());
                if(reaccion.getTweet().getImageUrl()!=null){
                    System.out.print("\n\tImage: "+reaccion.getTweet().getImageUrl());
                }
                if(reaccion.getTweet().getLinkUrl()!=null){
                    System.out.print("\n\tLink: "+reaccion.getTweet().getLinkUrl());
                }
            }
        }
    }
}
