package twitter;

import java.util.ArrayList;

public class Dashboard {
    private Usuario usuario;

    public Dashboard(Usuario usuario) {
        this.usuario = usuario;
    }

    public void verUltimosTweets(int limit){
        ArrayList<Tweet> tweets = BaseDeDatos.getTweets();
        ArrayList<Usuario> usuarios = this.usuario.seguimiento.getSeguidos();
        int count = 0;
        int cantidadTweets = tweets.size()-1;
        Tweet tweet;
        for(int i=cantidadTweets;i>=0;i--){
            tweet = tweets.get(i);
            if(usuarios.contains(tweet.getUsuario()) || tweet.getUsuario()==this.usuario){
                System.out.print("\n---------------------");
                System.out.print("\n\t*id: "+i+"\n\tAutor: "+tweet.getUsuario().getNombreUsuario()+
                        "\n\tTexto: "+tweet.getText());
                System.out.print("\n\tLikes: "+tweet.getNumeroFav()+"\tRts: "+tweet.getNumeroRt());
                if(tweet.getImageUrl()!=null){
                    System.out.print("\n\tImage: "+tweet.getImageUrl());
                }
                if(tweet.getLinkUrl()!=null){
                    System.out.print("\n\tLink: "+tweet.getLinkUrl());
                }
                if(!tweet.getRespuestas().isEmpty()){
                    System.out.print("\n\tRespuestas: ");
                    for(Respuesta respuesta: tweet.getRespuestas()){
                        System.out.print("\n\t\t\t*Usuario: "+respuesta.getUsuario().getNombreUsuario());
                        System.out.print("\n\t\t\tText: "+respuesta.getText());
                        if(respuesta.getImageUrl()!=null){
                            System.out.print("\n\t\t\tImage: "+respuesta.getImageUrl());
                        }
                        if(respuesta.getLinkUrl()!=null){
                            System.out.print("\n\t\t\tLink: "+respuesta.getLinkUrl());
                        }
                    }
                }
                count++;
                if(count>limit){
                    return;
                }
            }
        }
        System.out.println("\n\n");
    }
}
